﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class DetailSettingsForm : StylishForm
    {
        public DetailSettingsForm()
        {
            InitializeComponent();
            listBox1.ItemHeight = (int)(listBox1.Font.GetHeight() * 4) + 1;
            listBox1.Items.AddRange(SettingsXml.Instance.conditional_templates.ToArray());
        }
        
        private bool adding = false;

        //メモ：通常のWidthは335、拡大時は665
        const int stdWidth = 335;
        const int enlargedWidth = 665;

        private void Enlarge()
        {
            for (int i = stdWidth; i <= enlargedWidth; i += 15)
            {
                this.Width = i;
                this.Refresh();
            }
        }
        private void Reduction()
        {
            for (int i = enlargedWidth; i >= stdWidth; i -= 15)
            {
                this.Width = i;
                this.Refresh();
            }
        }

        private void addBtn_Click(object sender, EventArgs e)
        {
            adding = true;
            groupBox1.Enabled = false;
            Enlarge();
        }

        private void okBtn_Click(object sender, EventArgs e)
        {
            if (adding)
            {
                if (!(Convert.ToBoolean(titleBox.TextLength) || Convert.ToBoolean(artistBox.TextLength) || Convert.ToBoolean(albumBox.TextLength)))
                {
                    MessageBox.Show("曲名・アーティスト名・アルバム名のいずれか１つは入力してください。", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
                else if (string.IsNullOrWhiteSpace(templateBox.Text))
                {
                    MessageBox.Show("テンプレートを入力してください。", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
                listBox1.Items.Add(new ConditionItem()
                {
                    Title = titleBox.Text,
                    Artist = artistBox.Text,
                    Album = albumBox.Text,
                    Template = templateBox.Text
                });
                adding = false;
                groupBox1.Enabled = true;
                Reduction();
                foreach (Control o in groupBox2.Controls)
                {
                    var tb = o as TextBox;
                    if (tb != null) tb.Clear();
                }
            }
            else
            {
                SettingsXml.Instance.conditional_templates = new List<ConditionItem>(listBox1.Items.Cast<ConditionItem>());
                this.Close();
            }
        }

        private void cancelBtn_Click(object sender, EventArgs e)
        {
            if (adding)
            {
                adding = false;
                groupBox1.Enabled = true;
                Reduction();
                foreach (Control o in groupBox2.Controls)
                {
                    var tb = o as TextBox;
                    if (tb != null) tb.Clear();
                }
            }
            else
            {
                this.Close();
            }
        }

        private void listBox1_DrawItem(object sender, DrawItemEventArgs e)
        {
            e.DrawBackground();
            if (e.Index > -1) e.Graphics.DrawString(listBox1.GetItemText(listBox1.Items[e.Index]), e.Font, new SolidBrush(e.ForeColor), e.Bounds);
        }

        private void delBtn_Click(object sender, EventArgs e)
        {
            foreach (int i in listBox1.SelectedIndices) listBox1.Items.RemoveAt(i);
        }

        private void delAllBtn_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
        }

        private void listBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Delete) delBtn_Click(delBtn, EventArgs.Empty);
        }
    }
}
